//LidTopBorder.scad;

//All walls are the same height;

//This module defines the border between 
//the top of the lid and the walls of 
//the lid of a case;

//The border is made from two cylinders 
//parallel to the X axis, two cylinders 
//parallel to the Y axis, and four spheres, 
//one at each of the upper corners of the lid;

include <BATT_Dimensions.scad>

module LidTopBorder()
{

echo("Begin LidTopBorder");
    
//To the cylinder() function, 
//the Xs and Ys look like heights;
HeightX = WallInnerX +WallThickness;
HeightY = WallInnerY +WallThickness;

DeltaX = WallInnerX/2 +WallThickness/2;
DeltaY = WallInnerY/2 +WallThickness/2;
    
//The cylinders and the spheres all 
//have a common DeltaZ;  Phew;
DeltaZ = WallZ;

//All cylinders are created along the Z axis;
    
//Those parallel to the X axis need to 
//be rotated about the Y axis;

translate([-DeltaX, -DeltaY, DeltaZ])
rotate([0, 90, 0])
cylinder(h=HeightX, d=WallThickness, $fn=36);

translate([-DeltaX, DeltaY, DeltaZ])
rotate([0, 90, 0])
cylinder(h=HeightX, d=WallThickness, $fn=36);

//Those parallel to the Y axis need to 
//be rotated about the X axis;
    
translate([-DeltaX, DeltaY, DeltaZ])
rotate([90, 0, 0])
cylinder(h=HeightY, d=WallThickness, $fn=36);

translate([DeltaX, DeltaY, DeltaZ])
rotate([90, 0, 0])
cylinder(h=HeightY, d=WallThickness, $fn=36);

//The four spheres use the same 
//translation deltas as the four cylinders;   
translate([-DeltaX, -DeltaY, DeltaZ])
sphere(d=WallThickness, $fn=36);

translate([-DeltaX, DeltaY, DeltaZ])
sphere(d=WallThickness, $fn=36);

translate([DeltaX, -DeltaY, DeltaZ])
sphere(d=WallThickness, $fn=36);

translate([DeltaX, DeltaY, DeltaZ])
sphere(d=WallThickness, $fn=36);


}
//
